;;########################################################################
;; correctest1.lsp
;; Copyright (c) 2000-2001 by Pedro M. Valero
;; Continuation of ViSta Plugin for test Analysis.
;;########################################################################

; PLUGIN STEP 3: DEFPROTO


(defproto test-model-proto
  '(data solutions solutions-file forms-file forms forms-var items-vars corrected-matrix corrected-matrix-no-nil right-num wrong-num null-num num-alternatives scale scale-if n-items n-items-1 item-variances item-std item-kurtosis item-skewness scale-variance scale-variance-if scale-std scale-std-if scale-skewness scale-skewness-if scale-kurtosis scale-kurtosis-if item-means scale-mean scale-mean-if  alfa alfa-if Split-Half scale-pares scale-impares cronbach kuder kuder-if data-index control-dicotomico p q p*q-if) 
;esto es para empezar creo que tendre que definir varios slots mas en el futuro
  () analysis-plugin-object-proto)
  
  
;; PLUGIN STEP 4: ISNEW
;;
;; The plugin's :isnew method MUST have exactly the same call-next-method
;; as is used below. You cannot add or remove arguments.

(defmeth test-model-proto :isnew 
  (solutions forms-file
             menu-item-title tool-name model-prefix ok-data-types 
             data title name dialog ok-variable-types)
  (if (not (equal data *current-data*))(setcd data))
      
  (call-next-method 
   menu-item-title tool-name model-prefix ok-data-types 
       data title name dialog ok-variable-types)
  )


; PLUGIN STEP 5: SLOT ACCESSORS

(defmeth test-model-proto :solutions 
  (&optional (list nil set))
  "List of correct answers"
  (if set (setf (slot-value 'solutions) list))
  (slot-value 'solutions))


(defmeth test-model-proto :solutions-file 
  (&optional (list nil set))
  "File of correct answers"
  (if set (setf (slot-value 'solutions-file) list))
  (slot-value 'solutions-file))

(defmeth test-model-proto :forms
  (&optional (list-of-lists nil set))
  "List of correspondence of questions"
  (if set (setf (slot-value 'forms) list-of-lists))
  (slot-value 'forms))

(defmeth test-model-proto :forms-file
  (&optional (file nil set))
  "File with the correct answers"
  (if set (setf (slot-value 'forms-file) file))
  (slot-value 'forms-file))

(defmeth test-model-proto :forms-var
  (&optional (var nil set))
  "Variable indicating wich form correspond to each row"
  (if set (setf (slot-value 'forms-var) var))
  (slot-value 'forms-var))

(defmeth test-model-proto :items-vars
  (&optional (vars nil set))
  "Variable indicating items analyzed"
  (if set (setf (slot-value 'items-vars) vars))
  (slot-value 'items-vars))

(defmeth test-model-proto :corrected-matrix
  (&optional (matrix nil set))
  "Matrix of 1 and 0 and nil for the items"
  (if set (setf (slot-value 'corrected-matrix) matrix))
  (slot-value 'corrected-matrix))

(defmeth test-model-proto :corrected-matrix-no-nil
  (&optional (matrix nil set))
  "Matrix of 1 and 0 for the items"
  (if set (setf (slot-value 'corrected-matrix-no-nil) matrix))
  (slot-value 'corrected-matrix-no-nil))


(defmeth test-model-proto :right-num
  (&optional (list nil set))
  "Number of right answers by case"
  (if set (setf (slot-value 'right-num) list))
  (slot-value 'right-num))

(defmeth test-model-proto :wrong-num
  (&optional (list nil set))
  "Number of wrong answers by case"
  (if set (setf (slot-value 'wrong-num) list))
  (slot-value 'wrong-num))


(defmeth test-model-proto :null-num
  (&optional (list nil set))
  "Number of null answers by case"
  (if set (setf (slot-value 'null-num) list))
  (slot-value 'null-num))

(defmeth test-model-proto :num-alternatives
  (&optional (list nil set))
  "Number of alternatives by question. This is taken from data so if any alternative is not used at all, it will not be counted"
  (if set (setf (slot-value 'num-alternatives) list))
  (slot-value 'num-alternatives))

(defmeth test-model-proto :cronbach
  (&optional (values nil set))
  (if set (setf (slot-value 'cronbach) values))
  (slot-value 'cronbach))

(defmeth test-model-proto :scale
  (&optional (values nil set))
  (if set (setf (slot-value 'scale) values))
  (slot-value 'scale))

(defmeth test-model-proto :scale-if
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-if) values))
  (slot-value 'scale-if))

(defmeth test-model-proto :n-items
  (&optional (values nil set))
  (if set (setf (slot-value 'n-items) values))
  (slot-value 'n-items))


(defmeth test-model-proto :item-variances
  (&optional (values nil set))
  (if set (setf (slot-value 'item-variances) values))
  (slot-value 'item-variances))

(defmeth test-model-proto :item-std
  (&optional (values nil set))
  (if set (setf (slot-value 'item-std) values))
  (slot-value 'item-std))

(defmeth test-model-proto :item-kurtosis
  (&optional (values nil set))
  (if set (setf (slot-value 'item-kurtosis) values))
  (slot-value 'item-kurtosis))

(defmeth test-model-proto :item-skewness
  (&optional (values nil set))
  (if set (setf (slot-value 'item-skewness) values))
  (slot-value 'item-skewness))

(defmeth test-model-proto :suma-item-variances
  (&optional (values nil set))
  (if set (setf (slot-value 'suma-item-variances) values))
  (slot-value 'suma-item-variances))

(defmeth test-model-proto :suma-item-variances-if
  (&optional (values nil set))
  (if set (setf (slot-value 'suma-item-variances-if) values))
  (slot-value 'suma-item-variances-if))

(defmeth test-model-proto :scale-variance
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-variance) values))
  (slot-value 'scale-variance))

(defmeth test-model-proto :scale-variance-if
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-variance-if) values))
  (slot-value 'scale-variance-if))

(defmeth test-model-proto :scale-std
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-std) values))
  (slot-value 'scale-std))

(defmeth test-model-proto :scale-std-if
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-std-if) values))
  (slot-value 'scale-std-if))

(defmeth test-model-proto :scale-kurtosis
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-kurtosis) values))
  (slot-value 'scale-kurtosis))

(defmeth test-model-proto :scale-kurtosis-if 
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-kurtosis-if) values))
  (slot-value 'scale-kurtosis-if))

(defmeth test-model-proto :scale-skewness
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-skewness) values))
  (slot-value 'scale-skewness))

(defmeth test-model-proto :scale-skewness-if
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-skewness-if) values))
  (slot-value 'scale-skewness-if))


(defmeth test-model-proto :item-means
  (&optional (values nil set))
  (if set (setf (slot-value 'item-means) values))
  (slot-value 'item-means))

(defmeth test-model-proto :scale-mean
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-mean) values))
  (slot-value 'scale-mean))

(defmeth test-model-proto :scale-mean-if
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-mean-if) values))
  (slot-value 'scale-mean-if))

(defmeth test-model-proto :alfa
  (&optional (values nil set))
  (if set (setf (slot-value 'alfa) values))
  (slot-value 'alfa))

(defmeth test-model-proto :alfa-if
  (&optional (values nil set))
  (if set (setf (slot-value 'alfa-if) values))
  (slot-value 'alfa-if))

(defmeth test-model-proto :Split-Half
  (&optional (values nil set))
  (if set (setf (slot-value 'Split-Half) values))
  (slot-value 'Split-Half))

(defmeth test-model-proto :scale-pares
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-pares) values))
  (slot-value 'scale-pares))

(defmeth test-model-proto :scale-impares
  (&optional (values nil set))
  (if set (setf (slot-value 'scale-impares) values))
  (slot-value 'scale-impares))

(defmeth test-model-proto :kuder
  (&optional (values nil set))
  (if set (setf (slot-value 'kuder) values))
  (slot-value 'kuder))

(defmeth test-model-proto :kuder-if
  (&optional (values nil set))
  (if set (setf (slot-value 'kuder-if) values))
  (slot-value 'kuder-if))

(defmeth test-model-proto :data-index
  (&optional (values nil set))
  (if set (setf (slot-value 'data-index) values))
  (slot-value 'data-index))

(defmeth test-model-proto :control-dicotomico
  (&optional (values nil set))
  (if set (setf (slot-value 'control-dicotomico) values))
  (slot-value 'control-dicotomico))

(defmeth test-model-proto :p
  (&optional (values nil set))
  (if set (setf (slot-value 'p) values))
  (slot-value 'p))

(defmeth test-model-proto :q
  (&optional (values nil set))
  (if set (setf (slot-value 'q) values))
  (slot-value 'q))

(defmeth test-model-proto :p*q-if
  (&optional (values nil set))
  (if set (setf (slot-value 'p*q-if) values))
  (slot-value 'p*q-if))

